function [msg]=writeAnalyze(filename,varargin)
%[msg]=writeAnalyze(filename,hdr,img)
%write to Analyze files.
%Input:
% filename: a string
% hdr: a hdr structure
% img: a img matrix
%
% hdr example:
%  hdr.db_name = '                  '
%  hdr.dim = [64 64 18]
%  hdr.vox = [3.1250 3.1250 5]
%  hdr.scale = 1
%  hdr.datatype = 'int16'
%  hdr.offset = 0
%  hdr.origin = [0 0 0]
%  hdr.descrip = '*** fMRIDC Cleaned Analyze Compatible File ***'
%  hdr.byte_order = 'ieee-be'
%
%[msg]=writeAnalyze(filename,Az)
%Input:
%  Az: a analyze structure
%   
%Definition of the structure Az is in readAnalyze.m

if(length(varargin)==1),
    Az = varargin{1};
    hdr = Az.hdr;
    img = Az.img;
elseif(length(varargin)==2),
    hdr =  varargin{1};
    img =  varargin{2};
else
    error('too many input arguments');
end

[path,name,ext]=fileparts(filename);
hdrFile = fullfile(path,[name '.hdr']);
imgFile = fullfile(path,[name '.img']);

rawhdr = hdr2rawhdr(hdr);
writerawhdr(hdrFile,rawhdr);
writeimg(imgFile,img,hdr.datatype,hdr.byte_order);


msg='ok';
return